/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util.auimlcvt;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OutputXML {
    private OutputXML() {
    }

    public static String buildStringFromXML(Document document) {
        StringBuffer sb = new StringBuffer(2048);
        OutputXML.buildStringFromNode(sb, document.getDocumentElement(), "");
        return sb.toString();
    }

    private static void buildStringFromNode(StringBuffer sb, Node node, String indent) {
        if (node.getNodeType() == 1) {
            sb.append(indent).append("<");
            if (node.getNamespaceURI() != null) {
                sb.append(node.getNamespaceURI()).append(":");
            }
            sb.append(node.getNodeName());
            NamedNodeMap attrs = node.getAttributes();
            int attrsLength = attrs.getLength();
            int i = 0;
            while (i < attrsLength) {
                Node attr = attrs.item(i);
                if (attr.getNamespaceURI() != null) {
                    sb.append(" ").append(attr.getNamespaceURI()).append(":").append(attr.getNodeName()).append("=\"").append(attr.getNodeValue()).append("\"");
                } else {
                    sb.append(" ").append(attr.getNodeName()).append("=\"").append(attr.getNodeValue()).append("\"");
                }
                ++i;
            }
            NodeList children = node.getChildNodes();
            if (children != null && children.getLength() > 0) {
                int childrenLength = children.getLength();
                sb.append(">\n");
                int i2 = 0;
                while (i2 < childrenLength) {
                    OutputXML.buildStringFromNode(sb, children.item(i2), indent + "  ");
                    ++i2;
                }
                if (node.getNamespaceURI() != null) {
                    sb.append(indent).append("</").append(node.getNamespaceURI()).append(":").append(node.getNodeName()).append(">\n");
                } else {
                    sb.append(indent).append("</").append(node.getNodeName()).append(">\n");
                }
            } else {
                sb.append("/>\n");
            }
        } else if (node.getNodeType() == 3) {
            sb.append(indent).append(node.getNodeValue()).append("\n");
        }
    }

    public static void outputXML(OutputStream out, Node rootNode) throws IOException {
        DataOutputStream dos = new DataOutputStream(out);
        OutputXML.outputNode(new DataOutputStream(out), rootNode, "");
    }

    private static void outputNode(DataOutputStream out, Node node, String indent) throws IOException {
        if (node.getNodeType() == 1) {
            out.writeBytes(indent + "<");
            if (node.getNamespaceURI() != null) {
                out.writeBytes(node.getNamespaceURI() + ":");
            }
            out.writeBytes(node.getNodeName());
            NamedNodeMap attrs = node.getAttributes();
            int attrsLength = attrs.getLength();
            int i = 0;
            while (i < attrsLength) {
                Node attr = attrs.item(i);
                if (attr.getNamespaceURI() != null) {
                    out.writeBytes(" " + attr.getNamespaceURI() + ":" + attr.getNodeName() + "=\"" + attr.getNodeValue() + "\"");
                } else {
                    out.writeBytes(" " + attr.getNodeName() + "=\"" + attr.getNodeValue() + "\"");
                }
                ++i;
            }
            NodeList children = node.getChildNodes();
            if (children != null && children.getLength() > 0) {
                int childrenLength = children.getLength();
                out.writeBytes(">\n");
                int i2 = 0;
                while (i2 < childrenLength) {
                    OutputXML.outputNode(out, children.item(i2), indent + "  ");
                    ++i2;
                }
                if (node.getNamespaceURI() != null) {
                    out.writeBytes(indent + "</" + node.getNamespaceURI() + ":" + node.getNodeName() + ">\n");
                } else {
                    out.writeBytes(indent + "</" + node.getNodeName() + ">\n");
                }
            } else {
                out.writeBytes("/>\n");
            }
        } else if (node.getNodeType() == 3) {
            out.writeBytes(indent + node.getNodeValue() + "\n");
        }
    }

    public static void printXML(Node rootNode) {
        OutputXML.printNode(rootNode, "");
    }

    private static void printNode(Node node, String indent) {
        if (node.getNodeType() == 1) {
            System.out.print(indent + "<");
            if (node.getNamespaceURI() != null) {
                System.out.print(node.getNamespaceURI() + ":");
            }
            System.out.print(node.getNodeName());
            NamedNodeMap attrs = node.getAttributes();
            int attrsLength = attrs.getLength();
            int i = 0;
            while (i < attrsLength) {
                Node attr = attrs.item(i);
                if (attr.getNamespaceURI() != null) {
                    System.out.print(" " + attr.getNamespaceURI() + ":" + attr.getNodeName() + "=\"" + attr.getNodeValue() + "\"");
                } else {
                    System.out.print(" " + attr.getNodeName() + "=\"" + attr.getNodeValue() + "\"");
                }
                ++i;
            }
            NodeList children = node.getChildNodes();
            if (children != null && children.getLength() > 0) {
                int childrenLength = children.getLength();
                System.out.println(">");
                int i2 = 0;
                while (i2 < childrenLength) {
                    OutputXML.printNode(children.item(i2), indent + "  ");
                    ++i2;
                }
                if (node.getNamespaceURI() != null) {
                    System.out.println(indent + "</" + node.getNamespaceURI() + ":" + node.getNodeName() + ">");
                } else {
                    System.out.println(indent + "</" + node.getNodeName() + ">");
                }
            } else {
                System.out.println("/>");
            }
        } else if (node.getNodeType() == 3) {
            System.out.println(indent + node.getNodeValue());
        }
    }
}

